VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DPC_Inlay"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const C_ERRORRAISE As Long = 2500

Public PIN_Id As String
Public INL_Id  As String
Public INL_Code As String
Public INL_Name As String
Public INL_Desc As String
Public INL_Type As Long
Public INL_TypeDesc As String
Public INL_Vend As String
Public INL_Deliv As Long
Public INL_DelivDesc As String
Public INL_Purch As Long
Public INL_PurchDesc As String
Public INL_CE As Long

Public PIN_Code As String
Public PIN_Std As Boolean
Public PIN_SizeA As Double
Public PIN_SizeB As Double
Public PIN_Purch As eDPCInlayPurchaseType
Public PIN_PurchDesc As String
Public PIN_Deliv As eDPCInlayDelivery
Public PIN_DelivDesc As String
Public PIN_Order As Long
Public PIN_ExName As String
Public PIN_CE As Long

Public IMG_Id As Long
Public INL_IsCus As Boolean
Public INL_Text As String
Public Idx As String
Public RowStatus As eDPCRowStatus

Public INL_IdentNr As String
Public INL_IdentNrTmp As String

Private ms_Language_Code As String
Private ml_U_Code As Long

#If ENV = LIVE Then
Private mo_Db As Object
#Else
Private mo_Db As ARMSYSCOMLib.ArmDb
#End If

Private mo_Tools As DPC_Tools

Public OfferPrice As New Collection

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Property Let U_Code(al_Code As Long)
  ml_U_Code = al_Code
End Property

Property Let Language_Code(AString As String)
  ms_Language_Code = AString
End Property

Property Get Language_Code() As String
  Language_Code = ms_Language_Code
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
    If Not (lo_Db Is Nothing) Then
        Set mo_Db = lo_Db
    End If
  Exit Property
ErrHandler:
  Call ErrorHandler("ArmDb")
End Property

Public Function Load_A_COM() As Boolean
On Error GoTo ErrHandler

  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("Load_A_COM")
End Function

Property Get HasInlay() As Boolean
  HasInlay = INL_Id <> ""
End Property

Public Sub CopyFrom(ByVal ao_Inlay As DPC_Inlay)
On Error GoTo ErrHandler

Dim lo_OfferPos As DPC_OfferPos
Dim lo_OfferPosCopy As DPC_OfferPos
  
  PIN_Id = ao_Inlay.PIN_Id
  INL_Id = ao_Inlay.INL_Id
  INL_Code = ao_Inlay.INL_Code
  INL_Name = ao_Inlay.INL_Name
  INL_Desc = ao_Inlay.INL_Desc
  INL_Type = ao_Inlay.INL_Type
  INL_TypeDesc = ao_Inlay.INL_TypeDesc
  INL_Vend = ao_Inlay.INL_Vend
  INL_Deliv = ao_Inlay.INL_Deliv
  INL_DelivDesc = ao_Inlay.INL_DelivDesc
  INL_Purch = ao_Inlay.INL_Purch
  INL_PurchDesc = ao_Inlay.INL_PurchDesc
  INL_CE = ao_Inlay.INL_CE
  PIN_Code = ao_Inlay.PIN_Code
  PIN_Std = ao_Inlay.PIN_Std
  PIN_SizeA = ao_Inlay.PIN_SizeA
  PIN_SizeB = ao_Inlay.PIN_SizeB
  IMG_Id = ao_Inlay.IMG_Id
  INL_IsCus = ao_Inlay.INL_IsCus
  INL_Text = ao_Inlay.INL_Text
  PIN_Purch = ao_Inlay.PIN_Purch
  PIN_PurchDesc = ao_Inlay.PIN_PurchDesc
  PIN_Deliv = ao_Inlay.PIN_Deliv
  PIN_DelivDesc = ao_Inlay.PIN_DelivDesc
  PIN_Order = ao_Inlay.PIN_Order
  PIN_ExName = ao_Inlay.PIN_ExName
  PIN_CE = ao_Inlay.PIN_CE
  Idx = ao_Inlay.Idx
  
  For Each lo_OfferPos In OfferPrice
    Set lo_OfferPosCopy = ao_Inlay.GetOfferPos(lo_OfferPos.DOF_Id)
    If Not lo_OfferPosCopy Is Nothing Then
      Call lo_OfferPos.CopyFrom(lo_OfferPosCopy)
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("CopyFrom")
End Sub

Public Sub Clear()
On Error GoTo ErrHandler

  INL_Id = ""
  INL_Code = ""
  INL_Name = ""
  INL_Desc = ""
  INL_Type = eDPCInlayType.itNone
  INL_TypeDesc = ""
  INL_Vend = ""
  INL_Deliv = eDPCInlayDelivery.idUndef
  INL_DelivDesc = ""
  INL_Purch = eDPCInlayPurchaseType.ipUndef
  INL_PurchDesc = ""
  INL_CE = 0
  PIN_Code = ""
  PIN_Std = True
  PIN_SizeA = 0
  PIN_SizeB = 0
  IMG_Id = 0
  INL_IsCus = False
  INL_Text = ""
  PIN_Purch = eDPCInlayPurchaseType.ipUndef
  PIN_PurchDesc = ""
  PIN_Deliv = eDPCInlayDelivery.idUndef
  PIN_DelivDesc = ""
  PIN_ExName = ""
  PIN_CE = 0
  Exit Sub
ErrHandler:
  Call ErrorHandler("Clear")
End Sub

Public Function LoadInlay(ByVal as_INL_Id As String) As Boolean
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long

  LoadInlay = False
  Call Clear
  ls_req = "exec DPC_Inlay_sel $INL_Id$, $Language_Code$"
  
  ls_req = Replace(ls_req, "$INL_Id$", mo_Tools.SQLStr(as_INL_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr(Language_Code), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    INL_Id = mo_Db.GetFields(lc_Cursor, "PRD_Id")
    INL_Code = mo_Db.GetFields(lc_Cursor, "PRD_Code")
    INL_Name = mo_Db.GetFields(lc_Cursor, "PRD_Name")
    INL_Desc = mo_Db.GetFields(lc_Cursor, "PRD_Desc")
    INL_Type = mo_Db.GetFields(lc_Cursor, "INL_Type")
    INL_TypeDesc = mo_Db.GetFields(lc_Cursor, "INL_TypeDesc")
    INL_Deliv = mo_Db.GetFields(lc_Cursor, "INL_Deliv")
    INL_DelivDesc = mo_Db.GetFields(lc_Cursor, "INL_DelivDesc")
    INL_Purch = mo_Db.GetFields(lc_Cursor, "INL_Purch")
    INL_PurchDesc = mo_Db.GetFields(lc_Cursor, "INL_PurchDesc")
    INL_Vend = mo_Db.GetFields(lc_Cursor, "INL_Vend")
    IMG_Id = mo_Db.GetFields(lc_Cursor, "IMG_Id")
    INL_IsCus = StrComp(mo_Db.GetFields(lc_Cursor, "INL_IsCus"), "X", vbTextCompare) = 0
    INL_CE = mo_Db.GetFields(lc_Cursor, "INL_CE")
    PIN_Code = mo_Db.GetFields(lc_Cursor, "PRD_CodeAMC")
    PIN_Deliv = INL_Deliv
    PIN_DelivDesc = INL_DelivDesc
    PIN_Purch = INL_Purch
    PIN_PurchDesc = INL_PurchDesc
    PIN_CE = INL_CE
    PIN_ExName = mo_Db.GetFields(lc_Cursor, "PIN_ExName")
    LoadInlay = True
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadInlay")
End Function

Public Function LoadInlayCode(ByVal as_INL_Code As String) As Boolean
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long

  LoadInlayCode = False
  Call Clear
  ls_req = "exec DPC_Inlay_sel2 $INL_Code$, $Language_Code$"
  ls_req = Replace(ls_req, "$INL_Code$", mo_Tools.SQLStr(as_INL_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr(Language_Code), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    LoadInlayCode = LoadInlay(mo_Db.GetFields(lc_Cursor, "INL_Id"))
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadInlayCode")
End Function

Public Function GetOfferPos(ByVal al_DOF_Id As Long) As DPC_OfferPos
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos

  Set GetOfferPos = Nothing
  For Each lo_Offer In OfferPrice
    If lo_Offer.DOF_Id = al_DOF_Id Then
      Set GetOfferPos = lo_Offer
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetOfferPos")
End Function

Public Function GetOfferPosByTag(ByVal as_Tag As String) As DPC_OfferPos
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos

  Set GetOfferPosByTag = Nothing
  For Each lo_Offer In OfferPrice
    If StrComp(lo_Offer.DOF_Tag, as_Tag, vbTextCompare) = 0 Then
      Set GetOfferPosByTag = lo_Offer
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetOfferPosByTag")
End Function

Public Property Get INL_Surface() As Double
On Error GoTo ErrHandler

  INL_Surface = (PIN_SizeA * PIN_SizeB) / 1000000
  Exit Property
ErrHandler:
  Call ErrorHandler("INL_Surface")
End Property

Public Function CalcInlaySize(ByVal ao_Product As DPC_Product) As Boolean
On Error GoTo ErrHandler

Dim ld_InlayDec As Double

  Call ao_Product.InitInlayDec(ld_InlayDec)
  PIN_SizeA = ao_Product.RPL_PanA + ld_InlayDec
  PIN_SizeB = ao_Product.RPL_PanB + ld_InlayDec
  Exit Function
ErrHandler:
  Call ErrorHandler("CalcInlaySize")
End Function

Public Function ReplaceValuePlaceholder(ByVal as_Text As String) As String
On Error GoTo ErrHandler

  as_Text = Replace(as_Text, "$PIN_Id$", PIN_Id, , , vbTextCompare)
  as_Text = Replace(as_Text, "$INL_Type$", INL_Type, , , vbTextCompare)
  as_Text = Replace(as_Text, "$INL_Code$", INL_Code, , , vbTextCompare)
  as_Text = Replace(as_Text, "$INL_Name$", INL_Name, , , vbTextCompare)
  as_Text = Replace(as_Text, "$INL_Desc$", INL_Desc, , , vbTextCompare)
  as_Text = Replace(as_Text, "$INL_Deliv$", INL_Deliv, , , vbTextCompare)
  as_Text = Replace(as_Text, "$INL_DelivDesc$", INL_DelivDesc, , , vbTextCompare)
  as_Text = Replace(as_Text, "$INL_Purch$", INL_Purch, , , vbTextCompare)
  as_Text = Replace(as_Text, "$INL_PurchDesc$", INL_PurchDesc, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PIN_Code$", PIN_Code, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PIN_Std$", mo_Tools.BoolToScreen(PIN_Std), , , vbTextCompare)
  as_Text = Replace(as_Text, "$PIN_SizeA$", mo_Tools.DblToScreen(PIN_SizeA), , , vbTextCompare)
  as_Text = Replace(as_Text, "$PIN_SizeB$", mo_Tools.DblToScreen(PIN_SizeB), , , vbTextCompare)
  as_Text = Replace(as_Text, "$PIN_Purch$", PIN_Purch, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PIN_PurchDesc$", PIN_PurchDesc, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PIN_Deliv$", PIN_Deliv, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PIN_DelivDesc$", PIN_DelivDesc, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PIN_Order$", PIN_Order, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PIN_ExName$", PIN_ExName, , , vbTextCompare)
  ReplaceValuePlaceholder = as_Text
  Exit Function
ErrHandler:
  Call ErrorHandler("ReplaceValuePlaceholder")
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub




